<?php

/**
 * JLCW starter theme functions and definitions
 */

namespace JLCW_Startertheme;

use \Elementor\Widget_Button_JLCW;
use \ElementorPro\Modules\Posts\Widgets\Posts_JLCW;
use \ElementorPro\Modules\Posts\Skins;

class JLCW_Startertheme
{
    public function __construct()
    {

    }

    public function init()
    {

        $this->initCustomPostType();
        $this->loadDependencies();
        $this->addImageSizes();
        $this->initTheme();
        $this->registerMenus();
        $this->initAdmintheme();
    }

    public function initCustomPostType()
    {

    }

    public function loadDependencies()
    {
        add_action( 'elementor/widget/posts/skins_init', function( $widget ) {
            require_once self::getIncDir() . 'elementor-widgets/posts_skin_gremmos.php';
            $widget->add_skin( new \ElementorPro\Modules\Posts\Skins\Skin_Gremmos( $widget ) );

        } );

        add_action('elementor/widgets/widgets_registered', array(&$this, 'register_elementor_widgets'));
    }

    public function addImageSizes()
    {

    }

    public function initTheme()
    {
        add_action('wp_enqueue_scripts', array(&$this, 'initScript'), 50);

    }

    public function registerMenus()
    {

    }

    public function initAdmintheme()
    {

    }

    public function register_elementor_widgets()
    {

        require_once self::getIncDir() . 'elementor-widgets/button.php';
        require_once self::getIncDir() . 'elementor-widgets/posts.php';


        $widgets_manager = \Elementor\Plugin::instance()->widgets_manager;

        $widgets_manager->register_widget_type(new Widget_Button_JLCW());
        $widgets_manager->register_widget_type(new Posts_JLCW());

    }



    public static function getIncDir()
    {

        return get_stylesheet_directory() . '/inc/';
    }

    public function initScript()
    {
        wp_register_script('bundlejs', get_stylesheet_directory_uri() . '/dist/bundle.js', false, null, true);

        wp_enqueue_style('slickcss', '//cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
        wp_enqueue_style('slickthemecss', '//cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick-theme.min.css');

        wp_enqueue_style('parent-theme', get_template_directory_uri() . '/style.css');
        wp_enqueue_style('child-theme', get_stylesheet_directory_uri() . '/dist/style.min.css');


        wp_enqueue_script('bundlejs');
    }

}


// Initialize the above class after theme setup
add_action('after_setup_theme', function () {
    global $theme;
    $theme = new JLCW_Startertheme();

    $theme->init();


});

